/*
 Copyright 2023 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { createSqliteBackend } from "./SqliteBackend.js";
import { BridgeIDBFactory } from "./bridge-idb.js";
import { IDBFactory } from "./idbtypes.js";
import { createNodeHelperSqlite3Impl } from "./node-helper-sqlite3-impl.js";

let idbFactory: IDBFactory | undefined = undefined;

export async function initTestIndexedDB(): Promise<void> {
  // const backend = new MemoryBackend();
  // backend.enableTracing = true;

  const sqlite3Impl = await createNodeHelperSqlite3Impl({
    enableTracing: false,
  });

  // const sqlite3Impl = await createNodeBetterSqlite3Impl();

  const backend = await createSqliteBackend(sqlite3Impl, {
    filename: ":memory:",
  });

  idbFactory = new BridgeIDBFactory(backend);
  backend.enableTracing = false;
  BridgeIDBFactory.enableTracing = false;
}

export function useTestIndexedDb(): IDBFactory {
  if (!idbFactory) {
    throw Error("indexeddb factory not initialized");
  }
  return idbFactory;
}
