/* odbcdefs.h: -*- C -*-  . */

/*  Copyright (c) 1996 Universal Access Inc.
            Henry Minsky (hqm@ua.com)
*/

#if !defined (_ODBCDEFS_H_)
#define _ODBCDEFS_H_

#if defined (OPENLINK_UDBC_CLIENT)
# define SQLRETCODE int

/* C to SQL datatype mapping */
# define SQL_SIGNED_OFFSET		(-20)
# define SQL_UNSIGNED_OFFSET		(-22)

# define SQL_C_SLONG			(SQL_C_LONG  + SQL_SIGNED_OFFSET)
# define SQL_C_SSHORT			(SQL_C_SHORT + SQL_SIGNED_OFFSET)


/* options for SQLSetConnectOption/SQLGetConnectOption */
# define SQL_CURRENT_QUALIFIER		109
# define SQL_ODBC_CURSORS		110
# define SQL_QUIET_MODE			111
# define SQL_PACKET_SIZE 		112

/* SQLGetInfo infor number */
# define SQL_NON_NULLABLE_COLUMNS	75
# define SQL_DRIVER_HLIB		76
# define SQL_QUALIFIER_LOCATION		114

#endif /* OPENLINK_UDBC_CLIENT */

/* Below are declarations for ODBC calls which we use. 
   The list below does not cover the complete ODBC
   spec,  so add declarations as you need them.   */
RETCODE SQLAllocConnect (HENV henv, HDBC FAR *phdbc);
RETCODE SQLAllocEnv (HENV FAR *phenv);
RETCODE SQLAllocStmt (HDBC hdbc, HSTMT FAR *phstmt);
RETCODE SQLExecDirect (HSTMT hstmt, UCHAR FAR  *szSqlStr, SDWORD cbSqlStr);

RETCODE SQLDriverConnect (HDBC hdbc,
			  PTR hwnd,
			  UCHAR FAR *szConnStrIn,
			  SWORD cbConnStrIn,
			  UCHAR FAR *szConnStrOut,
			  SWORD	cbConnStrOutMax,
			  SWORD FAR *pcbConnStrOut,
			  UWORD	fDriverCompletion);

RETCODE SQLDisconnect (HDBC hdbc);

RETCODE SQLError (HENV henv,
		  HDBC hdbc,
		  HSTMT hstmt,
		  UCHAR FAR *szSqlState,
		  SDWORD FAR *pfNativeError,
		  UCHAR FAR *szErrorMsg,
		  SWORD cbErrorMsgMax,
		  SWORD FAR *pcbErrorMsg);

RETCODE SQLPrepare (HSTMT hstmt, UCHAR FAR *szSqlStr, SDWORD cbStr);
RETCODE SQLExecute (HSTMT hstmt);
RETCODE SQLFetch (HSTMT hstmt);
RETCODE SQLFreeConnect (HDBC hdbc);
RETCODE SQLFreeEnv (HENV henv);
RETCODE SQLFreeStmt (HSTMT hstmt, UWORD fOption);

RETCODE SQLGetData (HSTMT hstmt, UWORD icol, SWORD fCType, PTR rgbValue,
		    SDWORD cbValueMax, SDWORD FAR *pcbValue);

RETCODE SQLDescribeCol (HSTMT hstmt,
			UWORD icol,
			UCHAR FAR *vcColName,
			SWORD FAR cbColNameMax,
			SWORD FAR *cbColName,
			SWORD FAR *fSqlType,
			UDWORD FAR *cbColDef,
			SWORD FAR *ibScale,
			SWORD FAR *fNullable);

RETCODE SQLRowCount (HSTMT hstmt, SDWORD FAR *pcrow);

RETCODE SQLColAttributes (HSTMT hstmt,
			  UWORD icol,
			  UWORD fDescType,
			  PTR rgbDesc,
			  SWORD cbDescMax,
			  SWORD FAR *pcbDesc,
			  SDWORD FAR *pfDesc);

RETCODE SQLTables (HSTMT hstmt,
		   UCHAR FAR *szCatalogName,
		   SWORD cbCatalogName,
		   UCHAR FAR *szSchemaName,
		   SWORD cbSchemaName,
		   UCHAR FAR *szTableName,
		   SWORD cbTableName,
		   UCHAR FAR *szTableType,
		   SWORD cbTableType);

RETCODE SQLColumns (HSTMT hstmt,
		    UCHAR FAR *szCatalogName,
		    SWORD cbCatalogName,
		    UCHAR FAR *szSchemaName,
		    SWORD cbSchemaName,
		    UCHAR FAR *szTableName,
		    SWORD cbTableName,
		    UCHAR FAR *szColumnName,
		    SWORD cbColumnName);

RETCODE SQLGetTypeInfo (HSTMT hstmt, SWORD fSqlType);

RETCODE SQLDataSources (HENV henv,
			UWORD fDirection,
			UCHAR FAR *szDSN,
			SWORD cbDSNMax,
			SWORD FAR *pcbDSN,
			UCHAR FAR *szDescription,
			SWORD cbDescriptionMax,
			SWORD FAR *pcbDescription);

RETCODE SQLTransact (HENV henv, HDBC hdbc, UWORD fType);
RETCODE SQLCancel (HSTMT hstmt);
RETCODE SQLNumResultCols (HSTMT hstmt, SWORD FAR *pcol);

RETCODE SQLBindCol (HSTMT hstmt, 
		    UWORD icol,
		    SWORD fCType,
		    PTR rgbValue,
		    SDWORD cbValueMax,
		    SDWORD FAR * pcbValue);

RETCODE SQLGetInfo (HDBC hdbc,
		    UWORD fInfoType,
		    PTR rgbInfoValue,
		    SWORD cbInfoValueMax,
		    SWORD FAR * pcbInfoValue);

RETCODE SQLGetConnectOption (HDBC hdbc, UWORD fOption, PTR pvParam);
RETCODE SQLSetConnectOption (HDBC hdbc, UWORD fOption, UDWORD pvParam);

#endif /* _ODBCDEFS_H_ */
