/* -*- c++ -*- */
/*
 * Copyright 2004 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "usrp_common.h"

void
set_led_0 (unsigned char on)
{
  if (on)
    USRP_MISC |= bmMISC_LED0;
  else
    USRP_MISC &= ~bmMISC_LED0;
}

void 
set_led_1 (unsigned char on)
{
  if (on)
    USRP_MISC |= bmMISC_LED1;
  else
    USRP_MISC &= ~bmMISC_LED1;
}

void
toggle_led_0 (void)
{
  USRP_MISC ^= bmMISC_LED0;
}

void
toggle_led_1 (void)
{
  USRP_MISC ^= bmMISC_LED1;
}

/* ---------------------------------------------------------------- */

void
la_trace_init (void)
{
  if (UC_TRACE_USING_PORT_A){
    IOA = 0xff;	// ensure that clock is high
  }
}

void
set_sleep_bits (unsigned char bits, unsigned char mask)
{
  bits &= 0x0f;
  mask &= 0x0f;
  
  USRP_MISC = (USRP_MISC & ~mask) | (bits & mask);
}

void
init_board (void)
{
  la_trace_init ();
}
